﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    protected void btnAdd_Click(object sender, EventArgs e)
    {
        //var to store the description
        string ItemDescription;
        //var to store the system ID of the item
        string PrimaryKeyValue;
        //get the item's system ID entered by the user
        PrimaryKeyValue = txtPrimaryKey.Text;
        //get the description entered by the user
        ItemDescription = txtToDo.Text;
        //create a new instance of ListItem
        ListItem NewEntry = new ListItem(ItemDescription, PrimaryKeyValue);
        //add the new item to the list
        lstToDo.Items.Add(NewEntry);
        //clear the text boxes
        txtToDo.Text = "";
        txtPrimaryKey.Text = "";
    }
    protected void btnRemove_Click(object sender, EventArgs e)
    {
        //declare a variable to store the selected index
        Int32 AnIndex;
        //obtain the selected index from the list
        AnIndex = lstToDo.SelectedIndex;
        //if the user has made a selection
        if (AnIndex != -1)
        {
            //has the user been asked if they mean it?
            if (btnCancel.Visible == true)
            {
                //remove the item identified by the selected index
                lstToDo.Items.RemoveAt(AnIndex);
                //set the error label to blank
                lblError.Text = "";
                //hide the cancel button
                btnCancel.Visible = false;
            }
            else
            {
                //make sure the user means it
                btnCancel.Visible = true;
                lblError.Text = "Press remove a second time to remove the entry or press cancel.";
            }
        }
        else
        {
            //if no selection made show an error message
            lblError.Text = "You must select an item on the list to remove it";
        }
    }
    protected void btnEdit_Click(object sender, EventArgs e)
    {
        //declare a variable to store the selected index
        Int32 AnIndex;
        //declare a variable to store the item to edit
        string AnItem;
        //get the selected index
        AnIndex = lstToDo.SelectedIndex;
        //if an item has been selected
        if (AnIndex != -1)
        {
            //get the selected value
            AnItem = lstToDo.SelectedValue;
            //remove it from the list
            lstToDo.Items.RemoveAt(AnIndex);
            //make the data available for editing
            txtToDo.Text = AnItem;
        }
        else
        {
            //display an error
            lblError.Text = "You must select an item before you can edit it.";
        }
    }
    protected void btnCancel_Click(object sender, EventArgs e)
    {
        btnCancel.Visible = false;
        lblError.Text = "";
    }

    protected void lstToDo_SelectedIndexChanged(object sender, EventArgs e)
    {
        //display the selected index
        txtSelectedIndex.Text =Convert.ToString( lstToDo.SelectedIndex);
        //display the selected value
        txtSelectedValue.Text = lstToDo.SelectedValue;
        //display the text
        txtSelectedItem.Text = lstToDo.SelectedItem.Text;
    }
}